﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;

using System.Collections.Generic;

public partial class LINQ_to_XML : System.Web.UI.Page
{
    private const string nazwaPlikuXML = @"d:\Ustawienia.xml"; //lokalny, na komputerze-kliencie

    protected void Page_Init(object sender, EventArgs e)
    {
        try
        {
            XDocument xml = XDocument.Load(nazwaPlikuXML);

            //odczytanie pozycji i wielkości
            TextBox1.Text = xml.Root.Element("strona").Element("TextBox1").Element("Text").Value;
        }
        catch (Exception exc)
        {
            TextBox1.Text = "Błąd podczas odczytywania pliku XML:\n" + exc.Message;
        }

    }

    protected void Page_Load(object sender, EventArgs e)
    {
        if (!System.IO.File.Exists(nazwaPlikuXML))
        {
            Label1.Text = "<BR><FONT COLOR='red'>Brak pliku XML <I>" + nazwaPlikuXML + "</I>!</FONT>";
            return;
        }

        XDocument xml = XDocument.Load(nazwaPlikuXML);

        string s = "<BR><FONT COLOR='navy'>Własności pliku XML <I>" + nazwaPlikuXML + "</I></FONT>:<BR>";

        //wersja XML
        string wersja = xml.Declaration.Version;
        s += "<BR>Wersja XML: " + wersja + "<BR>";

        //odczytanie nazwy głównego elementu
        string nazwaElementuGlownego = xml.Root.Name.LocalName;
        s += "<BR>Nazwa elementu głównego: " + nazwaElementuGlownego + "<BR>";

        //kolekcja podelementów ze wszystkich poziomów drzewa
        IEnumerable<XElement> wszystkiePodelementy = xml.Root.Descendants();
        s += "<BR>Wszystkie podelementy:<BR>";
        foreach (XElement podelement in wszystkiePodelementy) s += podelement.Name + "<BR>";

        //kolekcja podelementow elementu okno
        IEnumerable<XElement> podelementyStrona = xml.Root.Element("strona").Elements();
        s += "<BR>Podelementy elementu strona:<BR>";
        foreach (XElement podelement in podelementyStrona) s += podelement.Name + "<BR>";

        Label1.Text = s;
    }

    protected void Button1_Click(object sender, EventArgs e)
    {
        XDocument xml = new XDocument(
               new XDeclaration("1.0", "utf-8", "yes"),
               new XComment("Zawartość pola tekstowego"),
               new XElement("opcje",
                   new XElement("strona",
                       new XAttribute("nazwa", this.Title),
                       new XElement("TextBox1",
                           new XElement("Text", this.TextBox1.Text)
                       )
                   )
               )
           );

        xml.Save(nazwaPlikuXML);
    }
}
